<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="jp.co.intra_mart.foundation.context.Contexts" %>
<%@ page import="jp.co.intra_mart.foundation.context.model.AccountContext" %>
<%@ page import="jp.co.intra_mart.foundation.admin.account.AccountInfoManager" %>
<%@ page import="jp.co.intra_mart.common.aid.jdk.java.text.ISO8601DateFormat" %>
<%@ page import="jp.co.intra_mart.foundation.i18n.datetime.format.AccountDateTimeFormatter" %>
<%@ page import="jp.co.intra_mart.foundation.i18n.datetime.format.DateTimeFormatIds" %>

<%@ page import="jp.co.intra_mart.cookbook.im_cookbook_116892.LoginDateRegisterCertificationListener" %>

<%
String IS_NOT_SET_YET = "-";

String userCd = Contexts.get(AccountContext.class).getUserCd();
AccountInfoManager accountInfoManager = new AccountInfoManager();

String loginDate = accountInfoManager.getAttribute(userCd,
                                                   LoginDateRegisterCertificationListener.ATTR_NAME_4_BEFORE_LAST_LOGIN_DATE,
                                                   IS_NOT_SET_YET);
if (!IS_NOT_SET_YET.equals(loginDate)) {
    loginDate = AccountDateTimeFormatter.format(ISO8601DateFormat.parse(loginDate), 
                                                DateTimeFormatIds.IM_DATETIME_FORMAT_DATE_STANDARD, 
                                                DateTimeFormatIds.IM_DATETIME_FORMAT_TIME_TIMESTAMP);
}

String loginIpAddress = accountInfoManager.getAttribute(userCd, 
                                                        LoginDateRegisterCertificationListener.ATTR_NAME_4_BEFORE_LAST_LOGIN_IP_ADDRESS,
                                                        IS_NOT_SET_YET);

String loginUserAgent = accountInfoManager.getAttribute(userCd, 
                                                        LoginDateRegisterCertificationListener.ATTR_NAME_4_BEFORE_LAST_LOGIN_USER_AGENT,
                                                        IS_NOT_SET_YET);
%>

<div class="imui-form-container">

  <table class="imui-form">
    <tr>
      <th><label>Last login date</label></th>
      <td><%=loginDate %></td>
    </tr>
    <tr>
      <th><label>IP address</label></th>
      <td><%=loginIpAddress %></td>
    </tr>
    <tr>
      <th><label>User Agent</label></th>
      <td><%=loginUserAgent %></td>
    </tr>
  </table>

</div>
