package jp.co.intra_mart.cookbook.im_cookbook_116892;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.intra_mart.common.aid.jdk.java.text.ISO8601DateFormat;
import jp.co.intra_mart.common.platform.log.Logger;
import jp.co.intra_mart.foundation.admin.account.AccountInfoManager;
import jp.co.intra_mart.foundation.admin.account.model.AccountInfo;
import jp.co.intra_mart.foundation.admin.exception.AdminException;
import jp.co.intra_mart.foundation.context.Contexts;
import jp.co.intra_mart.foundation.context.model.AccountContext;
import jp.co.intra_mart.foundation.http.utility.InetAddressDetectException;
import jp.co.intra_mart.foundation.http.utility.InetAddressDetector;
import jp.co.intra_mart.foundation.security.certification.CertificationStatus;
import jp.co.intra_mart.foundation.security.certification.model.LoginInfo;
import jp.co.intra_mart.foundation.security.certification.provider.UserCertificationListener;

public class LoginDateRegisterCertificationListener implements UserCertificationListener {

    private static final String ATTR_NAME_PREFIX = "im_cookbook_116892.";

    public static final String ATTR_NAME_4_LAST_LOGIN_DATE = ATTR_NAME_PREFIX + "LAST_LOGIN_DATE";

    public static final String ATTR_NAME_4_LAST_LOGIN_IP_ADDRESS = ATTR_NAME_PREFIX + "LAST_LOGIN_IP_ADDRESS";

    public static final String ATTR_NAME_4_LAST_LOGIN_USER_AGENT = ATTR_NAME_PREFIX + "LAST_LOGIN_USER_AGENT";

    public static final String ATTR_NAME_4_BEFORE_LAST_LOGIN_DATE = ATTR_NAME_PREFIX + "BEFORE_LAST_LOGIN_DATE";

    public static final String ATTR_NAME_4_BEFORE_LAST_LOGIN_IP_ADDRESS = ATTR_NAME_PREFIX + "BEFORE_LAST_LOGIN_IP_ADDRESS";

    public static final String ATTR_NAME_4_BEFORE_LAST_LOGIN_USER_AGENT = ATTR_NAME_PREFIX + "BEFORE_LAST_LOGIN_USER_AGENT";

    private static final String HEADER_NAME_4_AUTHORIZATION = "Authorization";

    private static final String HEADER_NAME_4_USER_AGENT = "User-Agent";

    private static final Logger LOGGER = Logger.getLogger();

    @Override
    public void doCertification(final CertificationStatus status, final LoginInfo loginInfo, final AccountInfo user, final HttpServletRequest request, final HttpServletResponse response) {

        if (status == CertificationStatus.CR_OK) {

            final String authorizationHeader = request.getHeader(HEADER_NAME_4_AUTHORIZATION);
            if (authorizationHeader != null) {
                LOGGER.trace("Ignore Basic Authentication etc. - authorizationHeader: {}", authorizationHeader);
                return;
            }

            // Change data
            changeLastDataWithBeforeLastData(user.getUserCd());

            final AccountInfoManager accountInfoManager = new AccountInfoManager();

            try {
                // Set : last login date
                final AccountContext accountContext = Contexts.get(AccountContext.class);
                final Date loginTime = accountContext.getLoginTime();
                accountInfoManager.setAttribute(user.getUserCd(), ATTR_NAME_4_LAST_LOGIN_DATE, ISO8601DateFormat.format(loginTime));

                // Set : ip address
                String ipAddress = "Unknown";
                final InetAddress remoteAddress = InetAddressDetector.getRemoteAddress(request);
                if (remoteAddress != null) {
                    ipAddress = remoteAddress.getHostAddress();
                }
                accountInfoManager.setAttribute(user.getUserCd(), ATTR_NAME_4_LAST_LOGIN_IP_ADDRESS, ipAddress);

                // Set : user agent
                String userAgent = "Unknown";
                if (request.getHeader(HEADER_NAME_4_USER_AGENT) != null) {
                    userAgent = request.getHeader(HEADER_NAME_4_USER_AGENT);
                }
                accountInfoManager.setAttribute(user.getUserCd(), ATTR_NAME_4_LAST_LOGIN_USER_AGENT, userAgent);

                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("----------------------------------------");
                    LOGGER.trace("userCd: {}", user.getUserCd());
                    LOGGER.trace("loginTime: {}", loginTime);
                    LOGGER.trace("ipAddress: {}", ipAddress);
                    LOGGER.trace("userAgent: {}", userAgent);
                    LOGGER.trace("----------------------------------------");
                }

            } catch (UnknownHostException | InetAddressDetectException | AdminException e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }

        } else {
            LOGGER.trace("Certification failed. (status: {})", status);
        }

    }

    private void changeLastDataWithBeforeLastData(final String userCd) {

        try {
            final AccountInfoManager accountInfoManager = new AccountInfoManager();

            final String lastLoginDate = accountInfoManager.getAttribute(userCd, ATTR_NAME_4_LAST_LOGIN_DATE);
            if (lastLoginDate != null) {
                accountInfoManager.setAttribute(userCd, ATTR_NAME_4_BEFORE_LAST_LOGIN_DATE, lastLoginDate);
            }

            final String lastLoginIpAddress = accountInfoManager.getAttribute(userCd, ATTR_NAME_4_LAST_LOGIN_IP_ADDRESS);
            if (lastLoginIpAddress != null) {
                accountInfoManager.setAttribute(userCd, ATTR_NAME_4_BEFORE_LAST_LOGIN_IP_ADDRESS, lastLoginIpAddress);
            }

            final String userAgent = accountInfoManager.getAttribute(userCd, ATTR_NAME_4_LAST_LOGIN_USER_AGENT);
            if (userAgent != null) {
                accountInfoManager.setAttribute(userCd, ATTR_NAME_4_BEFORE_LAST_LOGIN_USER_AGENT, userAgent);
            }

        } catch (final AdminException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }

    }

}
